<?php
/**
 * اضافه کردن فیلدهای مربوط به اعلان مصرف به دیتابیس
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/config.php';

echo "<h1>🔧 اضافه کردن فیلدهای اعلان مصرف به دیتابیس</h1>";
echo "<style>body{font-family:Tahoma;padding:20px;direction:rtl;line-height:2;} .success{color:green;font-weight:bold;} .error{color:red;font-weight:bold;} .info{color:blue;}</style>";

$conn = getDBConnection();

// 1. فیلد usage_alert_sent - آیا اعلان ارسال شده؟
$checkSql = "SHOW COLUMNS FROM orders LIKE 'usage_alert_sent'";
$result = $conn->query($checkSql);

if ($result && $result->num_rows > 0) {
    echo "<p class='info'>ℹ️ فیلد usage_alert_sent قبلاً وجود دارد</p>";
} else {
    $sql = "ALTER TABLE orders ADD COLUMN usage_alert_sent TINYINT(1) DEFAULT 0 AFTER esim_status";
    
    if ($conn->query($sql)) {
        echo "<p class='success'>✅ فیلد usage_alert_sent با موفقیت اضافه شد</p>";
    } else {
        echo "<p class='error'>❌ خطا در اضافه کردن فیلد usage_alert_sent: " . $conn->error . "</p>";
    }
}

// 2. فیلد usage_alert_time - زمان ارسال اعلان
$checkSql2 = "SHOW COLUMNS FROM orders LIKE 'usage_alert_time'";
$result2 = $conn->query($checkSql2);

if ($result2 && $result2->num_rows > 0) {
    echo "<p class='info'>ℹ️ فیلد usage_alert_time قبلاً وجود دارد</p>";
} else {
    $sql2 = "ALTER TABLE orders ADD COLUMN usage_alert_time DATETIME NULL AFTER usage_alert_sent";
    
    if ($conn->query($sql2)) {
        echo "<p class='success'>✅ فیلد usage_alert_time با موفقیت اضافه شد</p>";
    } else {
        echo "<p class='error'>❌ خطا در اضافه کردن فیلد usage_alert_time: " . $conn->error . "</p>";
    }
}

// نمایش ساختار جدول
echo "<hr>";
echo "<h2>📋 ساختار جدول orders:</h2>";
$result = $conn->query("DESCRIBE orders");

if ($result) {
    echo "<table border='1' cellpadding='10' style='border-collapse:collapse;width:100%;'>";
    echo "<tr style='background:#667eea;color:white;'><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
    
    while ($row = $result->fetch_assoc()) {
        $highlight = (strpos($row['Field'], 'usage_alert') !== false) ? "style='background:#d1fae5;font-weight:bold;'" : "";
        echo "<tr $highlight>";
        echo "<td>" . $row['Field'] . "</td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "<td>" . ($row['Default'] ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
}

$conn->close();

echo "<hr>";
echo "<h2>📝 راهنمای تنظیم Cron Job:</h2>";
echo "<p>برای اجرای خودکار چک کردن مصرف، یکی از دستورات زیر را به cron اضافه کنید:</p>";
echo "<code style='background:#f0f0f0;padding:10px;display:block;margin:10px 0;direction:ltr;'>0 */6 * * * php /path/to/cron-check-usage.php</code>";
echo "<p>یا از طریق URL با کلید امنیتی:</p>";
echo "<code style='background:#f0f0f0;padding:10px;display:block;margin:10px 0;direction:ltr;'>https://yourdomain.com/cron-check-usage.php?key=esim_cron_2024_secret</code>";
?>

